/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * TD 9-2-06 QA70-9012 DYNACONTROL_MULTILINEEDIT_BUTTON							*
 *------------------------------------------------------------------------------*/


#ifndef _DYNACB_SPLITTER_H
#define _DYNACB_SPLITTER_H

#include "FunctionMgr.h"

class	TreeDynaSplitterWithCBCommunication	:	public TreeDynaSplitter
{
public:
	TreeDynaSplitterWithCBCommunication	()
	{
	}
	
	~TreeDynaSplitterWithCBCommunication()
	{
	}
public:
	TreeNode	GetSelFuncDetail()
	{
		return m_trFunctionDetail;
	}
protected:
	virtual BOOL	UpdateFuncDetail()	{return FALSE;}
	
protected:
	EVENTS_BEGIN
	// The following menu commands are not triggered by any menu or toolbar buttons. These
	// messages are triggered as result of adding the particular ID's (e.g. IDC_OPEN_IN_CODE_BUILDER_BUTTON_FIT_FUNCTION)
	// in the TreeNode representing a multilen edit (e.g. Look at FitNL.cpp)
	ON_MENU_CMD(IDC_OPEN_IN_CODE_BUILDER_BUTTON_FIT_FUNCTION, OnOpenInCodeBuilderFitFunction)
	ON_MENU_CMD(IDC_OPEN_IN_CODE_BUILDER_BUTTON_PARA_INIT, OnOpenInCodeBuilderParaInit)
	ON_USER_MSG(WM_USER_ON_CONTENT_CHANGE, OnContentChange)	
	EVENTS_END

	BOOL 	OnOpenInCodeBuilderFitFunction()
	{
		if( UpdateFuncDetail() )
		{
			Functions.EditFunctionInCodeBuilder(m_trFunctionDetail, *this);
			return TRUE;
		}
		
		return FALSE;
	}
	
	BOOL 	OnOpenInCodeBuilderParaInit()
	{
		if( UpdateFuncDetail() )
		{
			Functions.EditFunctionInCodeBuilder(m_trFunctionDetail, *this, TRUE);
			return TRUE;
		}
		
		return FALSE;
	}

	void OnContentChange(DWORD wParam, DWORD lParam)
	{
		switch( (uint) lParam )
		{
		case FUNCTION_MANAGER_ON_CODE_BUILDER_OPEN_FUNCTION:
			OnCodeBuilderBeginEdit();
			break;
			
		case FUNCTION_MANAGER_ON_CODE_BUILDER_CLOSE_FUNCTION:
			OnCodeBuilderEndEdit();
			break;
			
		case FUNCTION_MANAGER_ON_CODE_BUILDER_SAVE_FUNCTION:
			OnCodeBuilderSave();
			break;
		}
	}
	
	
	void	OnCodeBuilderBeginEdit()
	{
	}
	
	void	OnCodeBuilderEndEdit()
	{
	}
	
	virtual void	OnCodeBuilderSave()	
	{
		/// TD 9-2-06 QA70-9012 DYNACONTROL_MULTILINEEDIT_BUTTON
		UpdateDynaControl(true, 0, FALSE, DYNACONTROL_UPDATE_VALUE); //update the control's with changes made from code builder
		/// end DYNACONTROL_MULTILINEEDIT_BUTTON
	}
	
protected:
	Tree	m_trFunctionDetail;
};
/// end NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO

#endif //_DYNACB_SPLITTER_H

